/*
TEXTBESCHREIBUNG
*/
#include <EEPROM.h>                       //EEPROM Initialisierung

#include "WProgram.h"
void setup();
void loop();
int Bereit=0,Verwendet=0,Einleitung=0;    //Globale Variablen f\u00fcr die Statusbestimmungen
char Adresse[8],Dimm[3],Ziel[9]; //Globale Arrays zur Speicherung von Quell-/Ziel-Adressen und Dimmwert
char LPC[2];   //Array f\u00fcr R\u00fcckgabe "OK" bei erfolgreicher Speicherung

void setup()
{
Serial.begin(115200);                    //Initialisierung der Schnittstelle: 115200 Baud ; 8 Datenbits ; 1 Stoppbit ; No Parity 
if(Einleitung==0)                        //Begr\u00fcsungstext gesendet?
  {
    Serial.println("***************************************");
    Serial.println("* ARDUINO - EIB - DIMM&SCHALT-SENSOR  *");
    Serial.println("*    TEL07 AT   -   ANDREAS STRAUB    *");
    Serial.println("*       Studienarbeit 5.Semester      *");
    Serial.println("***************************************");
    Serial.println();
    Einleitung=1;                        //Begr\u00fcsungstext gesendet!
  }
Serial.println();                             //Men\u00fcanzeige
Serial.println("WAS MOECHTEN SIE TUN:");
Serial.println("--------------------------------------------------");
Serial.println("ZIELADRESSE:");
Serial.println("Neue Gruppenadresse des Zielobjektes eingeben  ->N");
Serial.println("Zuletzt Gespeicherte Gruppenadresse verwenden  ->G");
Serial.println("Zuletzt Verwendete Gruppenadresse verwenden    ->V");
Serial.println("--------------------------------------------------");
Serial.println("QUELLADRESSE:");
Serial.println("Absenderadresse des Sensors anzeigen           ->Q");
Serial.println("Absenderadresse des Sensors aendern            ->W");
Serial.println("--------------------------------------------------");
Serial.println("FUNKTIONEN:");
Serial.println("Ziel EIN-Schalten                              ->E");
Serial.println("Ziel AUS-Schalten                              ->A");
Serial.println("Ziel DIMMEN                                    ->D");
Serial.println("--------------------------------------------------");
Serial.print("Ihre Wahl:");
}

void loop()
{
char Wahl,Wahl2,Wahl3;        //Lokale Auswahlvariable
int i=0,d=0,s=0,n=0,Status=0;   //Lokale Ein-/Ausgabevariable

  if (Serial.available())     //Wenn Eingabe erfolgt
  {
    Wahl=Serial.read();       //Hole eingegebenes Zeichen
    Serial.println(Wahl);     //Zeige eingegebenes Zeichen
    switch(Wahl)              //Auswahlsteuerung
    {
    case 'n':                //Neue Gruppenadresse
      Serial.println("Bitte Zieladresse eingeben nach dem FORMAT BB/L/TTT"); 
      do {
         if (Serial.available()) 
         {
         Adresse[i]=Serial.read();  //Eingegebene Adresse dem Adressarray zuweisen
         i++;
         }
         } while (i<8);
      Serial.print("Neue Zieladresse ist: ");    
      for (d=0;d<8;d++)
         {
         Serial.print(Adresse[d]);    //Ausgabe der eingegebenen Adresse
         }
         Serial.println();
      Serial.print("Zieladresse Speichern j/n?: ");    //Soll diese Adresse fest gespeichert werden ->EEPROM
      
      do {
         if (Serial.available()) 
         {
          Wahl2=Serial.read();           
          Serial.println(Wahl2);
          switch(Wahl2) 
          {
          case 'j':                              //Speicherung
            Serial.println("GESPEICHERT!");
            for(s=0;s<8;s++)
              {
                EEPROM.write(s, Adresse[s]);      //Inhalt Adressarray wird dem EEPROM \u00fcbergeben und dort gespeichert
              }
            Status=1;
            break;
          case 'n':
            Serial.println("NICHTGESPEICHERT!");      //Keine Speicherung
            Status=1;
            break;
          default:
            Serial.println("FALSCHE EINGABE - Adresse NICHTGESPEICHERT!");    //Un\u00fcltige Eingabe
            Status=1;
           }
         }
         } while (Status==0);
         Bereit=1;        //Gruppenadresse ausgew\u00e4hlt!
         Verwendet=1;     //Gruppenadresse verwendet!
         delay(2000);
         setup();        //Men\u00fcanzeige erneut darstellen
         break;
    case 'g':    //Gespeicherte Gruppenadresse
      Serial.print("Zuletzt gespeicherte Gruppenadresse: ");
      for(i=0;i<8;i++)
              {
                Adresse[i]=EEPROM.read(i);       //Gespeicherte Gruppenadresse aus EEPROM holen und in Adressarray setzen
              }
      for (d=0;d<8;d++)
             {
             Serial.print(Adresse[d]);          //Ausgabe der gespeicherten Gruppenadresse
             }
      Serial.println(" ausgewaehlt");
      Bereit=1;                            //Gruppenadresse ausgew\u00e4hlt
      Verwendet=1;                         //Gruppenadresse verwendet
      delay(2000);
      setup();            //Men\u00fcanzeige erneut darstellen
      break;
    case 'v':            //Zuletzt verwendete Gruppenadresse
      if(Verwendet>0)    //Gruppenadresse schonmal verwendet?
        {
        Bereit=1;       //Gruppenadresse ausgew\u00e4hlt
        Serial.print("Zuletzt verwendete Gruppenadresse: ");
        for (d=0;d<8;d++)
             {
             Serial.print(Adresse[d]);        //Ausgabe der zuletzt verwendeten Gruppenadresse
             }
        Serial.println(" ausgewaehlt");
        }
      else        //Noch keine Gruppenadresse verwendet
        {
          Serial.println("Noch keine Gruppenadresse verwendet:");
          Serial.println("Bitte zuerst N oder G auswaehlen!");
        }
      delay(2000);
      setup();    //Men\u00fcanzeige erneut darstellen
      break;
    case 'd':           //AKTOR DIMMEN
      if(Bereit>0)      //Gruppenadresse ausgew\u00e4hlt?
        {
          Serial.println("AKTOR DIMMEN:");      //Ausw\u00e4hlbare Dimmwerte
          Serial.println("0%   ->0");
          Serial.println("25%  ->1");
          Serial.println("50%  ->2");
          Serial.println("75%  ->3");
          Serial.println("100% ->4");
          Serial.println("--------");
          Serial.print("Wert: ");          //Dimmwert ausw\u00e4hlen
          do {
             if (Serial.available()) 
             {
             Wahl3=Serial.read();
             Serial.println(Wahl3);
             switch(Wahl3)                //Ausgew\u00e4hler Dimmwert dem Dimmarray zuweisen
             {
            case '0':                    //Auf 0% Dimmen
            Dimm[0]='0';
            Dimm[1]='0';
            Dimm[2]='0';
            Status=1;
            break;
            case '1':                    //Auf 25% Dimmen
            Dimm[0]='0';
            Dimm[1]='6';
            Dimm[2]='4';
            Status=1;
            break;
            case '2':                    //Auf 50% Dimmen
            Dimm[0]='1';
            Dimm[1]='2';
            Dimm[2]='3';
            Status=1;
            break;
            case '3':                    //Auf 75% Dimmen
            Dimm[0]='1';
            Dimm[1]='9';
            Dimm[2]='2';
            Status=1;
            break;
            case '4':                    //Auf 100% Dimmen
            Dimm[0]='2';
            Dimm[1]='5';
            Dimm[2]='5';
            Status=1;
            break;
            default:                     //Un\u00fcltiger Wert ausgew\u00e4hlt
            Status=1;
            Serial.println("Ungueltiger Dimmwert!");
            }
            }
            } while (Status==0);
          delay(500);
          Serial.print("fbs06/");           //Ausgabe DIMMSTRING PART I
          for (d=0;d<8;d++)
             {
             Serial.print(Adresse[d]);     //Ausgabe DIMMSTRING PART II (Adresse)
             }
          Serial.print("=");
          for (d=0;d<3;d++)
             {
             Serial.print(Dimm[d]);        //Ausgabe DIMMSTRING PART III (Dimmwert)
             }
             Serial.println();
          Bereit=0;               //Keine Gruppenadresse ausgew\u00e4hlt!
          delay(500);
          do {
               LPC[n]=Serial.read();      //Erfolgreiche \u00c4nderung -> "OK" zur\u00fcck
               n++;
             } while (Serial.available()>0);    //R\u00fcckgabe vom LPC auslesen
             delay(500);
             Serial.print("Rueckgabe: ");
             for (d=0;d<2;d++)
             {
             Serial.print(LPC[d]);  //R\u00fcckgabe des LPC anzeigen
             }
        }
      else                                //Noch keine Gruppenadresse ausgew\u00e4hlt
        {
          Serial.println("Bitte zuerst N / G / V auswaehlen!");
        }
      Serial.println();  
      delay(2000);
      setup();            //Men\u00fcanzeige erneut darstellen
      break;
    case 'e':            //AKTOR EIN
      if(Bereit>0)       //Gruppenadresse ausgew\u00e4hlt?
        {
          Serial.println("AKTOR EIN:");
          delay(500);
          Serial.print("fbs01/");    //Ausgabe EINSTRING PART I
          for (d=0;d<8;d++)
             {
             Serial.print(Adresse[d]);    //Ausgabe EINSTRING PART II (Adresse)
             }
             Serial.println("=1");        //Ausgabe EINSTRING PART III
          Bereit=0;     //Keine Gruppenadresse ausgew\u00e4hlt!
          delay(500);
          do {
             LPC[n]=Serial.read();      //Erfolgreiche \u00c4nderung -> "OK" zur\u00fcck
             n++;
             } while (Serial.available()>0);    //R\u00fcckgabe vom LPC auslesen
             delay(500);
             Serial.print("Rueckgabe: ");
             for (d=0;d<2;d++)
             {
             Serial.print(LPC[d]);  //R\u00fcckgabe des LPC anzeigen
             }
        }
      else              //Noch keine Gruppenadresse ausgew\u00e4hlt
        {
          Serial.println("Bitte zuerst N / G / V auswaehlen!");
        }
      Serial.println(); 
      delay(2000);
      setup();          //Men\u00fcanzeige erneut darstellen
      break;
    case 'a':          //AKTOR AUS
       if(Bereit>0)    //Gruppenadresse ausgew\u00e4hlt?
         {
          Serial.println("AKTOR AUS:");    
          delay(500);
          Serial.print("fbs01/");          //Ausgabe AUSSTRING PART I
          for (d=0;d<8;d++)
             {
             Serial.print(Adresse[d]);    //Ausgabe AUSSTRING PART II (Adresse)
             }
          Serial.println("=0");          //Ausgabe AUSSTRING PART III
          Bereit=0;       //keine Gruppenadresse ausgew\u00e4hlt!
          delay(500);
          do {
             LPC[n]=Serial.read();      //Erfolgreiche \u00c4nderung -> "OK" zur\u00fcck
             n++;
            } while (Serial.available()>0);    //R\u00fcckgabe vom LPC auslesen
           delay(500);
           Serial.print("Rueckgabe: ");
           for (d=0;d<2;d++)
           {
           Serial.print(LPC[d]);  //R\u00fcckgabe des LPC anzeigen
           }
         }
       else      //Noch keine Gruppenadresse ausgew\u00e4hlt
        {
          Serial.println("Bitte zuerst N oder G auswaehlen!");
        }
      Serial.println();
      delay(2000);
      setup();    //Men\u00fcanzeige erneut darstellen
      break;
    case 'q':    //Eingestellte Quelladresse auslesen
       Serial.println("ABSENDER ANZEIEGEN:");
       Serial.println("fbrpa");      //Befehl zum auslesen senden
       delay(5000);
       do {
           Ziel[i]=Serial.read();
           i++;
          } while (Serial.available()>0);    //Quelladresse auslesen
       delay(500);
       Serial.print("Unsere Absenderadresse ist: ");
       for (d=0;d<i;d++)
         {
         Serial.print(Ziel[d]);      //Quelladresse anzeigen
         }
       Serial.println();
       delay(2000);
       setup();                //Men\u00fcanzeige erneut darstellen
       break;
    case 'w':                                    //Quelladresse \u00e4ndern
       Serial.println("ABSENDER AENDERN:");
       Serial.println("Bitte Absenderadresse eingeben nach dem FORMAT BB.LL.TTT");
       do {
         if (Serial.available()) 
          {
          Ziel[i]=Serial.read();      //Neue Quelladresse eingeben
          i++;
          }
          } while (i<9);
       Serial.print("Neue Absenderadresse ist: ");
       for (d=0;d<9;d++)
           {
           Serial.print(Ziel[d]);    //Neue Quelladresse anzeigen
           }
       Serial.println();
       delay(500);
       Serial.print("fbspa");      //Ausgabe AENDERUNGSTRING PART I
       for (d=0;d<9;d++)
           {
           Serial.print(Ziel[d]);  //Ausgabe AENDERUNGSTRING PART II (Quelladresse)
           }
           Serial.println();
       delay(500);
       do {
           LPC[n]=Serial.read();      //Erfolgreiche \u00c4nderung -> "OK" zur\u00fcck
           n++;
          } while (Serial.available()>0);    //R\u00fcckgabe vom LPC auslesen
       delay(500);
       Serial.print("Rueckgabe: ");
       for (d=0;d<2;d++)
           {
           Serial.print(LPC[d]);  //R\u00fcckgabe des LPC anzeigen
           }
       Serial.println();
       delay(2000);
       setup();          //Men\u00fcanzeige erneut darstellen
       break;
    default:                      //Falsche Eingabe
      Serial.println("FALSCHE EINGABE");
      delay(2000);
      setup();          //Men\u00fcanzeige erneut darstellen
    
    }
  }
  
} 

int main(void)
{
	init();

	setup();
    
	for (;;)
		loop();
        
	return 0;
}

